const form = document.getElementById('chat-form');
const msgInput = document.getElementById('message');
const chatBox = document.getElementById('chat-box');

form.onsubmit = (e) => {
  e.preventDefault();
  const formData = new FormData(form);
  fetch('post_message.php', {
    method: 'POST',
    body: formData
  }).then(() => {
    msgInput.value = '';
    document.getElementById('file').value = '';
    loadMessages();
  });
};

function loadMessages() {
  fetch('fetch_messages.php')
    .then(res => res.text())
    .then(data => {
      chatBox.innerHTML = data;
      chatBox.scrollTop = chatBox.scrollHeight;
    });
}

setInterval(loadMessages, 2000);
loadMessages();

const picker = new EmojiButton();
document.querySelector('#emoji-btn').addEventListener('click', () => {
  picker.togglePicker(document.querySelector('#emoji-btn'));
});
picker.on('emoji', emoji => {
  msgInput.value += emoji;
});