<?php
session_start();
$db = new PDO('sqlite:db/chat.db');
$messages = $db->query("SELECT messages.*, users.username FROM messages JOIN users ON messages.sender_id = users.id ORDER BY messages.timestamp DESC LIMIT 50")->fetchAll(PDO::FETCH_ASSOC);
$messages = array_reverse($messages);
foreach ($messages as $msg) {
    echo "<p><strong>" . htmlspecialchars($msg['username']) . "</strong>: " . htmlspecialchars($msg['message']);
    if ($msg['file_path']) {
        if (strpos($msg['mime_type'], 'image') === 0) {
            echo "<br><img src='" . $msg['file_path'] . "' width='200'>";
        } elseif (strpos($msg['mime_type'], 'video') === 0) {
            echo "<br><video controls width='250'><source src='" . $msg['file_path'] . "' type='" . $msg['mime_type'] . "'></video>";
        } else {
            echo "<br><a href='" . $msg['file_path'] . "' download>Download file</a>";
        }
    }
    echo "</p>";
}