<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Chat</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<h2>Welcome, <?= htmlspecialchars($_SESSION['user']) ?> <a href="logout.php">Logout</a></h2>
<div id="chat-box"></div>
<form id="chat-form" enctype="multipart/form-data">
    <input id="message" name="message" placeholder="Type a message..." required>
    <input type="file" id="file" name="file">
    <button type="submit">Send</button>
    <button type="button" id="emoji-btn">😊</button>
</form>
<script src="https://cdn.jsdelivr.net/npm/@joeattardi/emoji-button@4.6.2/dist/index.min.js"></script>
<script src="script.js"></script>
</body>
</html>